# Début programme de configuration en console de la sortie PWM programmable D3

# PWM est l'acronyme anglais de : Pulse Width Modulation
# Sortie PWM peut etre traduit en "Signal de périodique a largeur d'impulsion variable"
# -> Les paramètres de temps du singal sont programmable.
# -> L'amplitude du signal est elle fixe a 0 ou 5v (non programmable)

# Ce programme vous invite a saisir dans la console du programme les differents...
# ...parametre de configuration de la sortie PWM de la broche D3.

# Le fonctionnement et signigications des paramètres est détaillé dans PWM_D3_Détaillé.py

# Nous importons le seul élément Arduino de pyfirmata2Ext
from pyfirmata2Ext import Arduino

# Instanciation d'un objet représentant la carte Plug'Uno.
# Arduino.AUTODETECT peut être remplacé par l'identifiant de port-série (ex : "COM1").
# Arduino.AUTODETECT peut ne pas fonctionner correctement avec les port-serie Bluetooth.
plugUno = Arduino(Arduino.AUTODETECT)

# Quelque fonction pour vérifier la coherence des valeurs entrées au clavier.
def valeurPrescalerEstCorrecte(test):
    return False if (test != "1" and test != "8" and test != "32" and test != "64" and test != "128" and test != "256" and test != "1024") else True
def valeurPeriodeEstCorrecte(test) :
    try : test = int(test)
    except : return False
    if test < 0 or test > 255 : return False
    return True
def valeurDutyCycleEstCorrecte(test,periode) :
    try : test = int(test)
    except : return False
    if test < 0 or test > int(periode) : return False
    return True

terminerLeProgramme = False 
while terminerLeProgramme is not True :

    print(
        "\n"
        "Frequence PWM (Hz) = ( 8 000 000 / prescaler ) / periode "
        "\n"
    )

    valeurPrescaler = ""
    valeurPeriode = ""
    valeurDutyCycle = ""
    
    while valeurPrescalerEstCorrecte(valeurPrescaler) is not True :
        valeurPrescaler = input("Prescaler, saisir la valeur (1/8/32/64/128/256/1024) : ")

    while valeurPeriodeEstCorrecte(valeurPeriode) is not True :
        valeurPeriode = input("Periode, saisir la valeur (0~255) : ")

    while valeurDutyCycleEstCorrecte(valeurDutyCycle,valeurPeriode) is not True :
        valeurDutyCycle = input("Raport cyclique, saisir la valeur (0~"+valeurPeriode+") : ")

    plugUno.setPWMConfigD3(
        int(valeurPrescaler),
        int(valeurPeriode),
        int(valeurDutyCycle)
    )

    frequenceEffective = 8000000/int(valeurPrescaler)/int(valeurPeriode)
    rapportCycliqueEffectif = int(valeurDutyCycle) / int(valeurPeriode)

    print(
        "\n"
        "Frequence effective : "+"{:.2f}".format(frequenceEffective)+" Hz \n"
        "Raport cyclique : "+"{:.2f}".format(rapportCycliqueEffectif)+"\n\n"      
    )

    if input("Configurer de nouveau (oui/non) ? ") == "non" : terminerLeProgramme = True

# Arrete le signal le signal PWM avant de quiter
plugUno.setPWMConfigD3(1,0,0)

# Fermer la connection a Plug'Uno avant de quitter.
plugUno.exit()

# Met fin a l'exécution du programme Python.
#exit()

# Fin programme de configuration en console de la sortie PWM programmable D3
